#include-once
#cs

handy tricks and tips system..
by cor


	This began life inside the color pickin chooser, but I soon realized it was 
	too useful to be hidden away in there, and ripped it out into its own file, 
	so it can be included in other apps, even yours.

	It's mainly designed for small tools, things with compact GUI's, and slides 
	out of the bottom of them, with helpful information.


	Usage..
	
	First, include the tips system..

		#include <corz_tips.au3>
	
	You will then need to setup the location of the tips file in your parent 
	application. Maybe a wee section something like this..

		FileInstall("I:\work\dev\my app\tips.txt", $user_data_folder & "\tips.txt", 0)
		$tips = $user_data_folder & "\tips.txt"

	You will also want to check the "no_tips" flag in your application. If the 
	user checks the "no more tips" box, this will be set to 1 ($GUI_CHECKED), 
	though the user may have manually set this to something else, of course.

		global $no_tips = IniReadCheckboxValue($ini_path, $my_ini_section, "no_tips", $GUI_UNCHECKED)
		(you can call the variable whatever you like, it's purely for your own app's 
		use, though the ini value must remain "no_tips", so the tip system can use it)

	As the tips system is designed to run at an application's startup, obviously 
	the user will find it annoying if the tips pop up unwanted, so you can check 
	this ini flag before calling the tips system. If it's 1, don't call 'em.

	There's a checkbox inside the tip GUI enabling the user to set this, though 
	it's up to you to check the ini flag before calling the tips at startup, 
	maybe like this (after your main GUI has appeared)..

		if $no_tips = $GUI_UNCHECKED then
			ShowTips()
		endif


	Then, to see the tips, do..

		corz_TipsSystem(tips file, gui handle, ini path, ini section, name [, height [, width [, funcion [,tweak x [, tweak y [, overap]]]]]])

			tips file			=	String 

									full path to the tips file
									
									PC (CRLF) format with multiple line-breaks between entries.
									use unix "\n" to add linebreaks inside the entries themselves


			gui handle			=	Control ID 

									The handle (a control ID) of the parent application's main GUI.
									(or the GUI you would like to attach the tips to)


			ini path			=	String

									The ini file to read and write tips preferences to and from.

									This will generally be your main preferences ini
									though you can make one just for tips, if you like.


			ini section			=	String

									The name of the ini section to write to.
									It's okay to use your app's main prefs section, or you may want to 
									create a section just for tips.


			name				=	String

									A name for your tips, e.g. "funky ass tips".
									If the user dumps all the tips to a file, this will be inserted.
			

			height	[optional]	=	Integer

									Specify the height of the tips window.
									Defaults to 156 pixels.


			width	[optional]	=	Integer
									
									Specify the width of the tips window.

									Defaults to the same width as the parent app
									Anything less than 380 pixels will cause button overlapping


			funcion	[optional]	=	String	{name of function}

									The name of a functions you would like to perform periodically.

									(defaults to an empty string, and performs no function)

									If your application has any time-dependant activities, you can
									send the name of a function you would like called. The function
									will be called around ten times a second.

									corz clock uses this facility to keep itself updated, and give
									the vague appearance of multi-threading.


			tweak x [optional]	=	Integer
									(defaults to 0 (zero))

									Nudge the tips window along the X plane by this many pixels.

									You can use this for fine adjustment of the window position.
									Negative values are allowed.

									Note: These nudge values are added *before* the tips system
									has done any off-screen compensation calculations. 
									See notes (below).

									Leave blank "", or set to zero to get the default.


			tweak y [optional]	=	Integer
									(defaults to 0 (zero))

									Nudge the tips window along the Y plane by this many pixels.
									etc.
									

			position [optional]	=	string
									(defaults to false)
									
									settings:

									"center" or "centre"

										The tips system window will Ignore all X & Y settings and 
										centre the window on the user's screen.
									
									"left"
										
										The tips will slide out of the left hand side of the parent
										GUI. If this results in the tips being positioned off-screen
										either to the left or right, the tips system will compensate.
									
									"right"
										
										The tips will slide out of the right hand side of the parent
										GUI. Compensation as "left".

									"overlap"

										Ignore X & Y settings and error checking, and place the tips 
										directly over the main GUI. Nudge values will be honoured.

										If overlap is set to true, the tips system will bypass all
										the usual size and position checking routines and place
										the tips directly on top of the specified parent GUI.

										Caution: If the parent GUI is smaller than the tips, and is 
										in the bottom-right of the user's desktop, the tips would 
										be positioned partly off-screen.



	Notes:
			The tips system is designed to run at your application's launch. If 
			the user switches this off, the tips system will tell the user that 
			they can hold down the SHIFT key at launch to re-enable the tips, or 
			hit F1 for tips at any time. Onviously you will have to code these 
			things into your application, or else change the message to 
			something else. Check out the color pickin chooser for usage 
			examples.

			The tips window will usually slide out the bottom of your parent
			application's specified GUI, unless they have it at the bottom of
			the screen, in which case it will slide out of the top. If you 
			are tweaking the x & y values, those tweaks will be added *before*
			this has happened.

			You can query the $tips_live boolean variable at any time, to check 
			if the tips system is currently running (true if running).

#ce

#include <corz_essentials.au3>
#include <corz_gui_fx.au3>

; you can query this variable at any time (true if tips are running)..
global $tips_live = false

; tips and tricks..
func corz_TipsSystem($ts_file, $parent, $ts_path, $ts_sect, $ts_name, $ts_h="", $ts_w="", $ts_func="", $ts_tx=0, $ts_ty=0, $ts_pos="")

	if $tips_live then return
	if not $ts_file or not $parent or not $ts_path or not $ts_sect or not $ts_name then return

	global $tips_array = corz_GrabTips($ts_file)
	if $tips_array = 0 then global $tips_array[3] = [2, "no tips available", "sorree"]
	global $tips_ini_path = $ts_path
	global $tips_ini_section = $ts_sect
	global $tips_name = $ts_name
	global $do_func = $ts_func

	local $last_coord_mode = AutoItSetOption("GUICoordMode", 1)
	local $last_event_mode = AutoItSetOption("GUIOnEventMode", 1)
	local $corz_no_tips = IniReadCheckboxValue($tips_ini_path, $tips_ini_section, "no_tips", $GUI_UNCHECKED)

	; you might get off with not disabling your parent window, as they say, ymmv.
	GUISetState(@SW_DISABLE, $parent)

	global $tips_count = IniRead($tips_ini_path, $tips_ini_section, "tips_count", 0)
	$tips_count += 1 ; always start with the *next* trick
	if $tips_count < 1 or $tips_count >= $tips_array[0] then $tips_count = 1

	$parent_size = WinGetPos($parent)

	if not $ts_w then $ts_w = $parent_size[2] - 8	; width - 8, I'm guessing this is borders
	if not $ts_h then $ts_h = 156

	$ts_x  = $parent_size[0] ; x
	$ts_y = $parent_size[1] + $parent_size[3] ; y + height
	$tips_gui_fx = "Slide Top" ; by default we slide out of the bottom of the app's gui, from the top down ("Slide Top").
	$check_x = true
	$check_y = true
	$do_nudge = true

	switch $ts_pos

		case "left"
			$ts_y = $parent_size[1]
			$ts_x -= $ts_w + 8
			$tips_gui_fx = "Slide Right"

		case "right"
			$ts_y = $parent_size[1] ; y
			$ts_x += $parent_size[2] ; parent width
			$tips_gui_fx = "Slide Left"

		case "center", "centre" ; (I actually prefer the US spelling)
			$ts_y = -1
			$ts_x = -1
			$check_x = false
			$check_y = false
			$do_nudge = false
			$tips_gui_fx = "Explode"

		case "top"
			$tips_gui_fx = "Slide Bottom"
			$ts_y = $parent_size[1] - $ts_h - 24
			$do_nudge = false

		case "overlap"
			$ts_y = $parent_size[1] ; y

	endswitch

	; nudge tweaks..
	if $do_nudge then
		$ts_x += $ts_tx
		$ts_y += $ts_ty
	endif

	; positional error checking..
	if $check_x then
		if $ts_x > @DesktopWidth - $ts_w then $ts_x = @DesktopWidth - $ts_w - 4
		if $ts_x < 0 then $ts_x = 0
	endif

	if $check_y then
		if $ts_y > @DesktopHeight - $ts_h - 24 then
			switch $ts_pos
				case "left", "right"
					$ts_y = @DesktopHeight - $ts_h - 24
				case "bottom"
					continuecase
				case else
					$ts_y = $parent_size[1] - $ts_h - 24
					$tips_gui_fx = "Slide Bottom"
			endswitch

		elseif $ts_y < 0 then 
			switch $ts_pos
				case "left", "right"
					$ts_y = 0
				case "bottom"
					continuecase
				case else
					$ts_y = $parent_size[1] + $parent_size[3] ; y + height
					$tips_gui_fx = "Slide Top"
			endswitch
		endif
	endif

	global $gui_tips = GUICreate(" " & $tips_name & "..", $ts_w, $ts_h, $ts_x, $ts_y + $ts_ty, _
		BitOr($WS_CAPTION, $WS_POPUP, $WS_SYSMENU, $WS_SIZEBOX), $WS_EX_TOOLWINDOW, $parent)

	GUISetOnEvent($GUI_EVENT_CLOSE, "corz_DoneTips", $gui_tips)
	HotKeySet("{ESC}","corz_EscDoneTips")
	HotKeySet("{PGUP}","corz_PgUpPreviousTip")
	HotKeySet("{PGDN}","corz_PgDnNextTip")

	$edit_tricks = GUICtrlCreateEdit($tips_array[$tips_count], 5, 5 , $ts_w-10, $ts_h-30, _
																		BitOr($ES_MULTILINE, $WS_VSCROLL))
	GUICtrlSetResizing(-1, $GUI_DOCKBORDERS)


	$butt_copy_tip = GUICtrlCreateButton("copy tip", 5, $ts_h-20, 50, 18)
	GUICtrlSetOnEvent(-1, "corz_CopyTip")
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " copy the current tip to the clipboard ")

	$butt_dump_tip = GUICtrlCreateButton("dump to a file", 57, $ts_h-20, 70, 18)
	GUICtrlSetOnEvent(-1, "corz_DumpTips")
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " dump all the tips to a plain text file")


	$check_no_more_tips = GUICtrlCreateCheckbox("no startup tips", 137, $ts_h-22)
	GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " check this box to turn off the tips at startup ")
	GUICtrlSetState(-1, $corz_no_tips)

	$butt_first_tip = GUICtrlCreateButton("|<<", $ts_w-157, $ts_h-22, 28, 20)
	GUICtrlSetOnEvent(-1, "corz_FirstTip")
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " back to the first tip ")

	$butt_previous_tip = GUICtrlCreateButton("<<", $ts_w-127, $ts_h-22, 38, 20)
	GUICtrlSetOnEvent(-1, "corz_PreviousTip")
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " show the previous tip..	[Page UP] ")

	$butt_next_tip = GUICtrlCreateButton(">>", $ts_w-87, $ts_h-22, 38, 20)
	GUICtrlSetOnEvent(-1, "corz_NextTip")
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " show the next tip..	[Page DOWN] ")

	$butt_donetips = GUICtrlCreateButton("done!", $ts_w-37, $ts_h-22, 32, 20)
	GUICtrlSetOnEvent(-1, "corz_DoneTips")
	GUICtrlSetResizing(-1, $GUI_DOCKRIGHT+$GUI_DOCKBOTTOM+$GUI_DOCKWIDTH+$GUI_DOCKHEIGHT)
	GUICtrlSetTip(-1, " close the tips..	[Esc]" )
	GUICtrlSetState(-1, $GUI_DefButton)

	$tips_live = true
	$current_count = $tips_count
	corz_GUIAnimateOpen($gui_tips, $tips_gui_fx)
	WinSetOnTop($gui_tips, "", 1)

	$funcount = 0

	while $tips_live
		if $current_count <> $tips_count then
			$current_count = $tips_count
			GUICtrlSetData($edit_tricks, $tips_array[$tips_count])
		endif
		
		if $do_func <> "" and $funcount >= 4 then
			Call($do_func)
			$funcount = 0
		endif
		$funcount += 1
		Sleep(25)
	wend

	HotKeySet("{ESC}")
	HotKeySet("{PGUP}")
	HotKeySet("{PGDN}")

	$corz_no_tips = GUICtrlRead($check_no_more_tips)	
	IniWriteCheckBoxValue($tips_ini_path, $tips_ini_section, "no_tips", $corz_no_tips)
	IniWrite($tips_ini_path, $tips_ini_section, "tips_count", $tips_count)

	$seen_tips_warning = IniRead($tips_ini_path, $tips_ini_section, "seen_tips_warning", 0)
	if $corz_no_tips = 1 and $seen_tips_warning = 0 then
		WinSetOnTop($gui_tips, "", 0)
		MsgBox(0, "No More Tips For You!", "To enable startup tips again, hold down the SHIFT key at launch. " & @CRLF & _
										   "If you want the tips back at any time, hit F1.")
		IniWrite($tips_ini_path, $tips_ini_section, "seen_tips_warning", 1)
	endif
	AutoItSetOption("GUIOnEventMode", $last_event_mode)
	AutoItSetOption("GUICoordMode", $last_coord_mode)
	corz_GUIAnimateClose($gui_tips, $tips_gui_fx)
	;GUISwitch($parent) ; magic, and more magic *sigh*
	WinSetOnTop($gui_tips, "", 0)
	GUIDelete($gui_tips)
	GUISetState(@SW_ENABLE, $parent)
	GUISetState(@SW_SHOW, $parent) ; essential, if you want the calling app to work correctly
	WinActivate($parent) ;just sounds powerful
endfunc

func corz_CopyTip()
	ClipPut($tips_array[$tips_count])
endfunc

func corz_DumpTips()
	WinSetOnTop($gui_tips, "", 0)
	$save_to = IniRead($tips_ini_path, $tips_ini_section, "save_tips", @DesktopDir)
	$save_file = FileSaveDialog( "Dump ALL the tips to a text file..", $save_to, "text files (*.txt)" , 16 , $tips_name & ".txt")
	if $save_file = "" then 
		WinSetOnTop($gui_tips, "", 1)
		return
	endif
	IniWrite($tips_ini_path, $tips_ini_section, "save_tips", GetParent($save_file))
	$dump_string = $tips_name & ".." & @CRLF & @CRLF
	for $i = 1 to $tips_array[0]-1
		$dump_string &= "Tip " & $i & ".." & @CRLF & $tips_array[$i] & @CRLF & @CRLF & @CRLF
	next
	$dump_string &= ".." & @CRLF & "end of " & $tips_name & @CRLF
	$save_file = FileOpen($save_file, 2)
	FileWrite($save_file, $dump_string)
	FileClose($save_file)
	WinSetOnTop($gui_tips, "", 1)
endfunc


func corz_FirstTip()
	$tips_count = 1
endfunc

func corz_PgUpPreviousTip()
	if WinActive($gui_tips) then
		corz_PreviousTip()
	else
		HotKeyset("{PGUP}")
		Send("{PGUP}")
		HotKeySet("{PGUP}","corz_PgUpPreviousTip")
	endif
endfunc
func corz_PreviousTip()
	$tips_count -= 1
	if $tips_count < 1 then $tips_count = $tips_array[0]
endfunc

func corz_PgDnNextTip()
	if WinActive($gui_tips) then
		corz_NextTip()
	else
		HotKeyset("{PGDN}")
		Send("{PGDN}")
		HotKeySet("{PGDN}","corz_PgDnNextTip")
	endif
endfunc
func corz_NextTip()
	if not WinActive($gui_tips) then return
	$tips_count += 1
ConsoleWrite("tips_array[0]: " & $tips_array[0] & @LF)
ConsoleWrite("tips_count: " & $tips_count & @LF)

	if $tips_count > $tips_array[0] then $tips_count = 1
endfunc

func corz_EscDoneTips()
	if WinActive($gui_tips) then
		corz_DoneTips()
	else
		HotKeyset("{ESC}")
		Send("{ESC}")
		HotKeySet("{ESC}","corz_EscDoneTips")
	endif
endfunc
func corz_DoneTips()
	$tips_live = false
endfunc


; kinda _FileReadToArray
func corz_GrabTips($file)
	$corz_tipsfile = FileOpen($file, 0)
	if $corz_tipsfile = -1 then return 0

	$tmp_tricks = StringSplit(StringStripCR(FileRead($corz_tipsfile, FileGetSize($file))), @CRLF)
	FileClose($corz_tipsfile)

	; I like double carriage returns between entries in my tips file, more readable, editable, so..
	$tmp_str = ""
	for $i = 1 to $tmp_tricks[0]
		if $tmp_tricks[$i] <> "" and StringLeft($tmp_tricks[$i], 1) <> ";" then 
			$tmp_tricks[$i] = StringReplace($tmp_tricks[$i], '\n', @CRLF)
			$tmp_str &= $tmp_tricks[$i] & "|"
		endif
	next
	$tmp_str = StringTrimRight($tmp_str, 1)
	return StringSplit($tmp_str, "|")
endfunc 
